<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Post;

use Erlage\Photogram\Data\Dtos\Post\PostMetaHashtagsDTO;
use Erlage\Photogram\Data\Dtos\Post\PostDisplayContentDTO;

trait TraitPostSetters
{
    use TraitPostProperties;

    /**
     * @return static 
     */
    final public function setId(string $id)
    {
        $this -> id = $id;

        return $this;
    }

    /**
     * @return static 
     */
    public function setOwnerUserId(string $ownerUserId)
    {
        $this -> ownerUserId = $ownerUserId;

        return $this;
    }

    /**
     * @return static 
     */
    public function setDisplayCaption(string $displayCaption)
    {
        $this -> displayCaption = $displayCaption;

        return $this;
    }

    /**
     * @return static 
     */
    public function setDisplayLocation(string $displayLocation)
    {
        $this -> displayLocation = $displayLocation;

        return $this;
    }

    /**
     * @return static 
     */
    public function setDisplayContent(PostDisplayContentDTO $displayContent)
    {
        $this -> displayContent = $displayContent;

        return $this;
    }

    /**
     * @return static 
     */
    public function setMetaHashtags(PostMetaHashtagsDTO $metaHashtags)
    {
        $this -> metaHashtags = $metaHashtags;

        return $this;
    }

    /**
     * @return static 
     */
    public function setCacheLikesCount(string $cacheLikesCount)
    {
        $this -> cacheLikesCount = $cacheLikesCount;

        return $this;
    }

    /**
     * @return static 
     */
    public function setCacheCommentsCount(string $cacheCommentsCount)
    {
        $this -> cacheCommentsCount = $cacheCommentsCount;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampRegistration(string $stampRegistration)
    {
        $this -> stampRegistration = $stampRegistration;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampLastUpdate(string $stampLastUpdate)
    {
        $this -> stampLastUpdate = $stampLastUpdate;

        return $this;
    }
}
